SuperStrict

Framework openb3d.B3dglgraphics
Import brl.GLMax2D

?bmxng
Import brl.RandomDefault
Import BRL.TimerDefault
?

AppTitle = "3D Spline Demo by METATIGER"
EnablePolledInput()

' create 3D window
Graphics3D(1920, 1080, 0, 2, 60, 0, False)

' use always the same seed
SeedRnd 3

' number of waypoints
Local q:Int = 20

' Spline Variables
Global ptc:Float[q + 3, 3]
Global a:Float[3]
Global b:Float[3]
Global c:Float[3]
Global d:Float[3]
Global tim:Int[q + 3]
Global oc:Float[3]
Global cube:TMesh[q+1]
Local x:Float
Local y:Float
Local z:Float
Global t:Int
Global n:Int
Global tbeg:Int
Global ms:Int

' create 3D scene objects and camera
Local pivot:TPivot = CreatePivot()
Local camera:TCamera = CreateCamera()
Local sphere:TMesh = CreateSphere(8, pivot)
Local trace:TMesh = CreateMesh(pivot)
Local surf:TSurface = CreateSurface(trace)
Local tracer:TMesh = CreateSprite()
ScaleMesh tracer, 0.05, 0.05, 0.05
EntityFX trace, 1 + 16
EntityFX sphere, 1
EntityColor sphere, 0, 255, 0
PositionEntity camera, 0, 0, -50
EntityOrder sphere, -1

' create random cube waypoints
For Local n:Int = 1 To q

	' create a cube object and position it random
	cube[n] = CreateCube(pivot)
	ScaleEntity cube[n], 0.5, 0.5, 0.5
	EntityFX cube[n], 1
	RotateEntity cube[n], Float(Rnd(0, 360)), Float(Rnd(0, 360)), Float(Rnd(0, 360))
	MoveEntity cube[n], 0, 0, Float(Rnd(10, 25))
	EntityColor cube[n], 128, 128, 128
	
	' get cube position
	x = EntityX(cube[n], 1)
	y = EntityY(cube[n], 1)
	z = EntityZ(cube[n], 1)
	
	' Spline Initialization I
	ptc[n, 0] = x
	ptc[n, 1] = y
	ptc[n, 2] = z
	
	tim[n] = t
	t = t + Rand(1000, 3000)
		
Next

' Spline Initialization II
For Local nn:Int = 0 To 2

	ptc[0, nn] = ptc[q, nn]
	ptc[q + 1, nn] = ptc[1, nn]
	ptc[q + 2, nn] = ptc[2, nn]

Next
tim[q + 1] = t
tim[q + 2] = t + tim[2]
tim[0] = tim[q] - t
t = t + 1
n = 1

' main loop
While Not (KeyDown(KEY_ESCAPE) | AppTerminate())

	' Spline stuff II
	Local dy2:Float
	Local x3:Float
	Local xx3:Float
	Local v:Float
	Local vv:Float
	
	If t > tim[n + 1] Then
	
		n = n + 1
		
		If n > q Then
		
			n = 1
			'ms = 0
			tbeg = MilliSecs()
			
		End If
		
		For Local nn:Int = 0 To 2
		
			d[nn] = ptc[n, nn]
			c[nn] = (ptc[n + 1, nn] - ptc[n - 1, nn]) * 1.0 / (tim[n + 1] - tim[n - 1])
			dy2 = (ptc[n + 2, nn] - ptc[n, nn]) * 1.0 / (tim[n + 2] - tim[n])
			x3 = tim[n + 1] - tim[n]
			xx3 = x3 * x3
			b[nn] = (3 * ptc[n + 1, nn] - dy2 * x3 - 2 * c[nn] * x3 - 3 * d[nn]) * 1.0 / xx3
			a[nn] = (dy2 - 2 * b[nn] * x3 - c[nn]) * 1.0 / (3 * xx3)
			
		Next
		
	End If
	
	For Local nn:Int = 0 To 2
	
		v = t - tim[n]
		vv = v * v
		oc[nn] = a[nn] * vv * v + b[nn] * vv + c[nn] * v + d[nn]
		
	Next
	
	' position the sphere and turn the pivot
	PositionEntity sphere, oc[0], oc[1], oc[2]
	TurnEntity pivot, 0, 0.005, 0
	
	' render frame
	RenderWorld
	
	' draw the sphere line
	glEnable(GL_COLOR_MATERIAL)
	glEnable(GL_LINE_STIPPLE)
	glBegin(GL_LINES)
	Line3D(0, 0, 0, EntityX(sphere, 1), EntityY(sphere, 1), EntityZ(sphere, 1), 255, 255, 0)
	glEnd()
	glDisable(GL_COLOR_MATERIAL)
	
	' draw the tracer
	If MilliSecs() > ms + 60 Then
	
		PositionEntity tracer, EntityX(sphere), EntityY(sphere), EntityZ(sphere)
		AddToSurface(tracer, surf, trace, 0, 255, 255, 1)
		TurnEntity tracer, 0, 90, 0
		AddToSurface(tracer, surf, trace, 0, 255, 255, 1)
		
		ms = MilliSecs()
		
	EndIf
	PositionEntity tracer, 0, 0, 0
	
	' 2D output on 3D
	BeginMax2D()
	
		For Local nn:Int = 1 To q
		
			Local x:Float = EntityX(cube[nn], 1)
			Local y:Float = EntityY(cube[nn], 1)
			Local z:Float = EntityZ(cube[nn], 1)
		
			' project target cube position and draw its number
			CameraProject camera, x, y, z
			DrawText(nn, ProjectedX() - 5, ProjectedY() - 30)
			
			' colorize the cube red if it has been passed by the sphere
			If EntityDistance(sphere, cube[nn]) < 1 Then EntityColor cube[nn], 255, 0, 0
			
		Next

	EndMax2D()
	
	' if all cubes have been visited reset the cube color
	If n = q Then
		
		For Local nn:Int = 1 To q
			
			EntityColor cube[nn], 128, 128, 128
			
		Next
		
	EndIf
	
	t = MilliSecs() - tbeg
	
	Flip True
	
Wend

' ------------------------------------------------------------------------------------------------
' Draw a 3D line using OpenGL functions:
' glEnable(GL_COLOR_MATERIAL) / glBegin(GL_LINES) [...] glEnd() / glDisable(GL_COLOR_MATERIAL)
' ------------------------------------------------------------------------------------------------
Function Line3D:TMesh(x0:Float, y0:Float, z0:Float, x1:Float, y1:Float, z1:Float, r:Int = 255, g:Int = 255, b:Int = 255, a:Float = 1.0)
		
	SetColor r, g, b
	SetAlpha(a)
		
	glVertex3f(x0, y0, -z0)
	glVertex3f(x1, y1, -z1)
	
	SetAlpha(1.0)
			
End Function

' ----------------------------------------------------------------------------
' Adds a mesh to another mesh
' ----------------------------------------------------------------------------
Function AddToSurface(mesh:TMesh, surf:TSurface, singlesurfaceentity:TMesh, r:Int, g:Int, b:Int, a:Float)
	
	Local v:Int[3]
		
	Local surface:TSurface = GetSurface(mesh, 1)
	
	For Local i1:Int = 0 To CountTriangles(surface) - 1
			
		For Local i2:Int = 0 To 2
					
			Local oldv:Int = TriangleVertex(surface, i1, i2)
			TFormPoint VertexX(surface, oldv), VertexY(surface, oldv), VertexZ(surface, oldv), mesh, singlesurfaceentity
			v[i2] = AddVertex(surf, TFormedX(), TFormedY(), TFormedZ(), VertexU(surface, oldv), VertexV(surface, oldv))
			
			VertexNormal surf, v[i2], VertexNX(surface, oldv), VertexNY(surface, oldv), VertexNZ(surface, oldv)
			
			VertexColor surf, v[i2], r, g, b, a
						
		Next
		
		AddTriangle(surf, v[0], v[1], v[2])
				
	Next
	
End Function