#version 130

#ifdef GL_ES
precision mediump float;
#endif

// uniforms
uniform float time;
uniform vec2 resolution;
uniform vec2 mouse;
uniform sampler2D iChannel0;

// shadertoy emulation
#define iTime time
#define iResolution resolution
#define iMouse mouse

// --------[ Original ShaderToy begins here ]---------- //
//
// https://www.shadertoy.com/view/XlsSD2
//
// --------[ Original ShaderToy begins here ]---------- //

#define PI 3.1415926535897932384626433832795

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
    
	vec2 circleUv = uv;
    circleUv -= vec2(0.5);
	circleUv.x *= iResolution.x/iResolution.y;
    
    float bars = 24.0;
    
    // limiting it to the first pixel row: fft values
    float r = min(0.0,length(circleUv.x));
    // dont use values below 0.0
	float t = abs(atan(circleUv.x, circleUv.y) / PI);

        
    // the fft texture is made up of two rows of pixels:
    // first row is the fft value, the second is the wave form
    // 
    // details on that:
    // http://forum.openframeworks.cc/t/passing-fft-audio-data-into-a-shader-as-a-texture2d-object-shadertoy/13756
    float fft  = texture(iChannel0, vec2(floor(uv.x*bars)/bars,0.0)).r;
	float amp = (fft - uv.y)*100.0;
    
    
    float polar  = texture(iChannel0, vec2(t,r)).r;

    fragColor = vec4(vec3(polar),1.0);
  

    
	
}

// --------[ Original ShaderToy ends here ]---------- //

void main(void)
{
    mainImage(gl_FragColor, gl_FragCoord.xy);
}
