#version 130

#ifdef GL_ES
precision mediump float;
#endif

// uniforms
uniform float time;
uniform vec2 resolution;
uniform vec2 mouse;
uniform sampler2D iChannel0;

// shadertoy emulation
#define iTime time
#define iResolution resolution
#define iMouse mouse

// --------[ Original ShaderToy begins here ]---------- //
//
// https://www.shadertoy.com/view/MdVBW1
//
// --------[ Original ShaderToy begins here ]---------- //

float distFromMiddle(float n){
    return abs(.5-n);
}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = fragCoord/iResolution.xy;
    
    // move image right, flip left horizontally
    if (uv.x < .5){
    	uv.x = -uv.x+.5;        
    }else{
     	uv.x = uv.x-.5;        
    }    
    
    // Time varying pixel color
    float t = iTime/5.;    
    vec3 col = vec3(
        .2+.2*sin(t),
        .02,
        .2+.3*cos(t));
    
    //Apply FFT
	float s = texture(iChannel0, (uv.xy*.333)).r;
    col *= s/distFromMiddle(uv.y);
    col *= .22;
    
    // Output to screen
    fragColor = vec4(col,1.);
    
}

// --------[ Original ShaderToy ends here ]---------- //

void main(void)
{
    mainImage(gl_FragColor, gl_FragCoord.xy);
}
