#version 130

#ifdef GL_ES
precision mediump float;
#endif

// uniforms
uniform float time;
uniform vec2 resolution;
uniform vec2 mouse;
uniform sampler2D iChannel0;

// shadertoy emulation
#define iTime time
#define iResolution resolution
#define iMouse mouse

// --------[ Original ShaderToy begins here ]---------- //
//
// https://www.shadertoy.com/view/wlKyDy
//
// --------[ Original ShaderToy begins here ]---------- //

// Anti aliasing level
uint antiAliasing = 4U;

// Minimal bar count
const float minimalBarCount = 16.0;

// Maximal bar count
const float maximalBarCount = 64.0;

// Bar spacing
const float barSpacing = 0.25;

// Sample volume count
const uint sampleBassVolumeCount = 16U;

// Low background color
const vec4 lowBackgroundColor = vec4(0.0, 0.0625, 0.125, 1.0);

// High background color
const vec4 highBackgroundColor = vec4(0.03125, 0.03125, 0.03125, 1.0);

// Low volume color
const vec4 lowVolumeColor = vec4(0.0, 0.0, 1.0, 1.0);

// Middle volume color
const vec4 middleVolumeColor = vec4(0.0, 1.0, 0.0, 1.0);

// High volume color
const vec4 highVolumeColor = vec4(1.0, 0.0, 0.0, 1.0);

// Samples scene
vec4 SampleScene(const vec2 fragCoord)
{
    // Scene UV coordinates
    vec2 uv = fragCoord / iResolution.xy;
    
    // Samples bass volume sum
    float bass_volume_sum = 0.0f;
    for (uint x = 0U; x != sampleBassVolumeCount; x++)
    {
        bass_volume_sum += texture(iChannel0, vec2(float(x) / float(sampleBassVolumeCount * 4U), 0.0)).x;
    }
    
    // Number of columns
    float columns = round(mix(maximalBarCount, minimalBarCount, bass_volume_sum / float(sampleBassVolumeCount)));
    
    // Number of rows
    float rows = (columns * iResolution.y) / iResolution.x;
    
    // Current volume of sample
    float volume = ((fract(uv.x * float(columns) + (barSpacing * 0.5)) > barSpacing) && (fract(uv.y * float(rows) + (barSpacing * 0.5)) > barSpacing)) ? texture(iChannel0, vec2(floor(uv.x * columns) / columns, 0.0)).x : 0.0;
    
    // Renders visualization
    return (uv.y > volume) ? mix(lowBackgroundColor, highBackgroundColor, uv.y) : ((volume > 0.5) ? mix(middleVolumeColor, highVolumeColor, (volume - 0.5) * 2.0) : mix(lowVolumeColor, middleVolumeColor, volume * 2.0));
}

// Main entry point
void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
    // Samples subpixels of scene
    vec4 color_sum = vec4(0.0);
    for (uint x = 0U, y; x != antiAliasing; x++)
    {
        for (y = 0U; y != antiAliasing; y++)
        {
            color_sum += SampleScene(fragCoord + vec2(((float(x) + 0.5) / float(antiAliasing)) - 0.5, ((float(y) + 0.5) / float(antiAliasing)) - 0.5));
        }
    }
    fragColor = color_sum / float(antiAliasing * antiAliasing);
}

// --------[ Original ShaderToy ends here ]---------- //

void main(void)
{
    mainImage(gl_FragColor, gl_FragCoord.xy);
}
