#version 130

#ifdef GL_ES
precision mediump float;
#endif

// uniforms
uniform float time;
uniform vec2 resolution;
uniform vec2 mouse;
uniform sampler2D iChannel0;

// shadertoy emulation
#define iTime time
#define iResolution resolution
#define iMouse mouse

// --------[ Original ShaderToy begins here ]---------- //
//
// https://www.shadertoy.com/view/3lcfzN
//
// --------[ Original ShaderToy begins here ]---------- //

// Anti aliasing level
const uint antiAliasing = 8U;

// Minimal circle radius
const float minimalCircleRadius = 0.25;

// Maximal circle radius
const float maximalCircleRadius = 0.5;

// Rotations per second
const float rotationsPerSecond = 0.0625;

// Minimal bar count
const float minimalBarCount = 8.0;

// Maximal bar count
const float maximalBarCount = 16.0;

// Sample volume count
const uint sampleBassVolumeCount = 16U;

// Low background color
const vec4 lowBackgroundColor = vec4(0.0, 0.0625, 0.125, 1.0);

// High background color
const vec4 highBackgroundColor = vec4(0.03125, 0.03125, 0.03125, 1.0);

// Low volume color
const vec4 lowVolumeColor = vec4(0.0, 0.0, 1.0, 1.0);

// Middle volume color
const vec4 middleVolumeColor = vec4(0.0, 1.0, 0.0, 1.0);

// High volume color
const vec4 highVolumeColor = vec4(1.0, 0.0, 0.0, 1.0);

// Two pi
const float twoPi = 6.2831853071795864769252867665590057683943387987502116419498891846;

// Samples scene
vec4 SampleScene(const vec2 fragmentCoordinates)
{
    // UV coordinates
    vec2 uv = (fragmentCoordinates - (iResolution.xy * 0.5)) / min(iResolution.x, iResolution.y);
    
    // Samples bass volume
    float bass_volume = 0.0;
    for (uint x = 0U; x != sampleBassVolumeCount; x++)
    {
        bass_volume += texture(iChannel0, vec2(float(x) / float(sampleBassVolumeCount * 4U), 0.0)).x;
    }
    bass_volume /= float(sampleBassVolumeCount);
    
    // Circle radius
    float circle_radius = mix(minimalCircleRadius, maximalCircleRadius, bass_volume);
    
    // Bar count
    float bar_count = round(mix(maximalBarCount, minimalBarCount, bass_volume));
    
    // Sampled volume
    float volume = texture(iChannel0, vec2(floor((1.0 - (sqrt((uv.x * uv.x) + (uv.y * uv.y)) / circle_radius)) * bar_count) / bar_count, 0.0)).x;
    
    // Angle
    float angle = -iTime * twoPi * rotationsPerSecond;
    
    // Renders visualization
    return ((((uv.x * uv.x) + (uv.y * uv.y)) > (circle_radius * circle_radius)) || (((dot(vec2(-sin(angle), cos(angle)), normalize(uv)) + 1.0) * 0.5) > volume)) ? mix(lowBackgroundColor, highBackgroundColor, uv.y) : ((volume > 0.5) ? mix(middleVolumeColor, highVolumeColor, (volume - 0.5) * 2.0) : mix(lowVolumeColor, middleVolumeColor, volume * 2.0));
}

// Main entry point
void mainImage(out vec4 fragmentColor, in vec2 fragmentCoordinates)
{
    // Samples subpixels of scene
    vec4 color_sum = vec4(0.0);
    for (uint x = 0U, y; x != antiAliasing; x++)
    {
        for (y = 0U; y != antiAliasing; y++)
        {
            color_sum += SampleScene(fragmentCoordinates + vec2(((float(x) + 0.5) / float(antiAliasing)) - 0.5, ((float(y) + 0.5) / float(antiAliasing)) - 0.5));
        }
    }
    fragmentColor = color_sum / float(antiAliasing * antiAliasing);
}

// --------[ Original ShaderToy ends here ]---------- //

void main(void)
{
    mainImage(gl_FragColor, gl_FragCoord.xy);
}
