#version 130

#ifdef GL_ES
precision mediump float;
#endif

// uniforms
uniform float time;
uniform vec2 resolution;
uniform vec2 mouse;
uniform sampler2D iChannel0;

// shadertoy emulation
#define iTime time
#define iResolution resolution
#define iMouse mouse

// --------[ Original ShaderToy begins here ]---------- //
//
// https://www.shadertoy.com/view/XljBR3
//
// --------[ Original ShaderToy begins here ]---------- //

void mainImage( out vec4 O, in vec2 uv ) {

	vec2 mid = vec2(0.5+0.39*cos(iTime*0.01), 0.5);
	uv /= iResolution.y;
    vec2 v = uv - mid;
    float d = length(v);  
    float amp = texture(iChannel0, vec2(d*0.7, 0.0)).r;
    
    float a2 = amp * 6.28;
    vec2 p = d * vec2(cos(a2), sin(a2)) * 0.5;
    float bri = (d*amp / distance(p, v)) * 0.9;
	O = vec4(amp*1.5, (amp+bri)*0.5, bri, 1.0);
}

// --------[ Original ShaderToy ends here ]---------- //

void main(void)
{
    mainImage(gl_FragColor, gl_FragCoord.xy);
}
