#version 130

#ifdef GL_ES
precision mediump float;
#endif

// uniforms
uniform float time;
uniform vec2 resolution;
uniform vec2 mouse;
uniform sampler2D iChannel0;

// shadertoy emulation
#define iTime time
#define iResolution resolution
#define iMouse mouse

// --------[ Original ShaderToy begins here ]---------- //
//
// https://www.shadertoy.com/view/wd3XzS
//
// --------[ Original ShaderToy begins here ]---------- //

float sigmoid(float x)
{
    return 1. / (1. + exp(x));
}

vec3 sigmoid(vec3 xyz)
{
    return vec3(sigmoid(xyz.x), sigmoid(xyz.y), sigmoid(xyz.z));
}

float sample_at(float f)
{
    return texture(iChannel0, vec2(f / 16.0, 0.)).x;
}

float sample_multiple(float f)
{
    float delta = .1;
    return 0.2 * (sample_at(f - 2. * delta) + sample_at(f - delta) + sample_at(f) + sample_at(f + delta) + sample_at(f + 2. * delta));
}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (fragCoord.xy - 0.5) / iResolution.xy;
    uv = 2. * uv - 1.;
    uv.x *= iResolution.x/iResolution.y;

    vec2 center = vec2(0.);// 0.5 * vec2(cos(iTime), sin(iTime));
    float d = length(uv - center);

    float amplitude = sample_multiple(d * d);
    d -= amplitude;
    float weird = sigmoid(abs(uv.x) * abs(uv.y));
    float speed = 6. * amplitude * sin(iTime * weird * 0.005) * 0.001;
    float dist_diagonal = abs(abs(uv.x) - abs(uv.y));
    dist_diagonal += d * amplitude;
    dist_diagonal *= dist_diagonal;
    amplitude += .1 / (.1 + smoothstep(1., 0.1, dist_diagonal));
    float brightness = 3. * amplitude * sigmoid(sin(d * d * 16. - speed * iTime + 2. * speed * amplitude));

    vec3 col = sigmoid(vec3(uv, sin(iTime)));

    fragColor = vec4(col * brightness,1.0);
}

// --------[ Original ShaderToy ends here ]---------- //

void main(void)
{
    mainImage(gl_FragColor, gl_FragCoord.xy);
}
